--
-- PostgreSQL database dump
--

-- Dumped from database version 9.3.5
-- Dumped by pg_dump version 9.3.5
-- Started on 2015-09-06 03:30:19 COT

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 8 (class 2615 OID 163985)
-- Name: core; Type: SCHEMA; Schema: -; Owner: postgres

---crear lenguaje para pl/pgsql
CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
AS '$libdir/plpgsql', 'plpgsql_call_handler'
LANGUAGE c;

CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler;
--

CREATE SCHEMA core;


ALTER SCHEMA core OWNER TO pamplona;

--
-- TOC entry 7 (class 2615 OID 164323)
-- Name: web; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA web;


ALTER SCHEMA web OWNER TO pamplona;

--
-- TOC entry 196 (class 3079 OID 11754)
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- TOC entry 2154 (class 0 OID 0)
-- Dependencies: 196
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = core, pg_catalog;

--
-- TOC entry 227 (class 1255 OID 164157)
-- Name: f_core_i_aud_actividad(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_i_aud_actividad() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_actividad(acti_id,  acti_nombre,  acti_estado,  acti_url,  acti_fecharegistro,  acti_registradopor,  func_id, acti_operacion)
 VALUES(new.acti_id,  new.acti_nombre,  new.acti_estado,  new.acti_url,  new.acti_fecharegistro,  new.acti_registradopor,  new.func_id, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_i_aud_actividad() OWNER TO pamplona;

--
-- TOC entry 212 (class 1255 OID 164000)
-- Name: f_core_i_aud_control(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_i_aud_control() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_control(cont_id,  cont_revision,  cont_fragmento,  cont_fecharegistro,  cont_registradopor, cont_operacion)
 VALUES(new.cont_id,  new.cont_revision,  new.cont_fragmento,  new.cont_fecharegistro,  new.cont_registradopor, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_i_aud_control() OWNER TO pamplona;

--
-- TOC entry 221 (class 1255 OID 164104)
-- Name: f_core_i_aud_funcionalidad(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_i_aud_funcionalidad() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_funcionalidad(func_id,  func_nombre,  func_estado,  func_url,  func_fecharegistro,  func_registradopor,  modu_id, func_operacion)
 VALUES(new.func_id,  new.func_nombre,  new.func_estado,  new.func_url,  new.func_fecharegistro,  new.func_registradopor,  new.modu_id, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_i_aud_funcionalidad() OWNER TO pamplona;

--
-- TOC entry 215 (class 1255 OID 164025)
-- Name: f_core_i_aud_modulo(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_i_aud_modulo() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_modulo(modu_id,  modu_nombre,  modu_estado,  modu_url,  modu_fecharegistro,  modu_registradopor, modu_operacion)
 VALUES(new.modu_id,  new.modu_nombre,  new.modu_estado,  new.modu_url,  new.modu_fecharegistro,  new.modu_registradopor, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_i_aud_modulo() OWNER TO pamplona;

--
-- TOC entry 233 (class 1255 OID 164253)
-- Name: f_core_i_aud_permisos(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_i_aud_permisos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_permisos(perm_id,  perm_estado,  perm_fecharegistro,  perm_registradopor,  acti_id,  pers_id, perm_operacion)
 VALUES(new.perm_id,  new.perm_estado,  new.perm_fecharegistro,  new.perm_registradopor,  new.acti_id,  new.pers_id, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_i_aud_permisos() OWNER TO pamplona;

--
-- TOC entry 230 (class 1255 OID 164202)
-- Name: f_core_i_aud_persona(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_i_aud_persona() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_persona(pers_id,  pers_documento,  pers_primernombre,  pers_segundonombre,  pers_primerapellido,  pers_segundoapellido,  pers_genero,  pers_fechanacimiento,  pers_estado,  pers_fecharegistro,  pers_registradopor, pers_operacion)
 VALUES(new.pers_id,  new.pers_documento,  new.pers_primernombre,  new.pers_segundonombre,  new.pers_primerapellido,  new.pers_segundoapellido,  new.pers_genero,  new.pers_fechanacimiento,  new.pers_estado,  new.pers_fecharegistro,  new.pers_registradopor, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_i_aud_persona() OWNER TO pamplona;

--
-- TOC entry 228 (class 1255 OID 164159)
-- Name: f_core_u_aud_actividad(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_u_aud_actividad() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_actividad(acti_id,  acti_nombre,  acti_estado,  acti_url,  acti_fecharegistro,  acti_registradopor,  func_id, acti_operacion)
 VALUES(new.acti_id,  new.acti_nombre,  new.acti_estado,  new.acti_url,  new.acti_fecharegistro,  new.acti_registradopor,  new.func_id, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_u_aud_actividad() OWNER TO pamplona;

--
-- TOC entry 213 (class 1255 OID 164002)
-- Name: f_core_u_aud_control(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_u_aud_control() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_control(cont_id,  cont_revision,  cont_fragmento,  cont_fecharegistro,  cont_registradopor, cont_operacion)
 VALUES(new.cont_id,  new.cont_revision,  new.cont_fragmento,  new.cont_fecharegistro,  new.cont_registradopor, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_u_aud_control() OWNER TO pamplona;

--
-- TOC entry 222 (class 1255 OID 164106)
-- Name: f_core_u_aud_funcionalidad(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_u_aud_funcionalidad() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_funcionalidad(func_id,  func_nombre,  func_estado,  func_url,  func_fecharegistro,  func_registradopor,  modu_id, func_operacion)
 VALUES(new.func_id,  new.func_nombre,  new.func_estado,  new.func_url,  new.func_fecharegistro,  new.func_registradopor,  new.modu_id, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_u_aud_funcionalidad() OWNER TO pamplona;

--
-- TOC entry 210 (class 1255 OID 164027)
-- Name: f_core_u_aud_modulo(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_u_aud_modulo() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_modulo(modu_id,  modu_nombre,  modu_estado,  modu_url,  modu_fecharegistro,  modu_registradopor, modu_operacion)
 VALUES(new.modu_id,  new.modu_nombre,  new.modu_estado,  new.modu_url,  new.modu_fecharegistro,  new.modu_registradopor, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_u_aud_modulo() OWNER TO pamplona;

--
-- TOC entry 234 (class 1255 OID 164255)
-- Name: f_core_u_aud_permisos(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_u_aud_permisos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_permisos(perm_id,  perm_estado,  perm_fecharegistro,  perm_registradopor,  acti_id,  pers_id, perm_operacion)
 VALUES(new.perm_id,  new.perm_estado,  new.perm_fecharegistro,  new.perm_registradopor,  new.acti_id,  new.pers_id, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_u_aud_permisos() OWNER TO pamplona;

--
-- TOC entry 223 (class 1255 OID 164204)
-- Name: f_core_u_aud_persona(); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION f_core_u_aud_persona() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO core.aud_persona(pers_id,  pers_documento,  pers_primernombre,  pers_segundonombre,  pers_primerapellido,  pers_segundoapellido,  pers_genero,  pers_fechanacimiento,  pers_estado,  pers_fecharegistro,  pers_registradopor, pers_operacion)
 VALUES(new.pers_id,  new.pers_documento,  new.pers_primernombre,  new.pers_segundonombre,  new.pers_primerapellido,  new.pers_segundoapellido,  new.pers_genero,  new.pers_fechanacimiento,  new.pers_estado,  new.pers_fecharegistro,  new.pers_registradopor, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION core.f_core_u_aud_persona() OWNER TO pamplona;

--
-- TOC entry 224 (class 1255 OID 164155)
-- Name: pr_core_d_actividad(numeric, character varying); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_d_actividad(numeric, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN

 INSERT INTO core.aud_actividad(
acti_id,
acti_nombre,
acti_estado,
acti_url,
acti_fecharegistro,
acti_registradopor,
func_id,
acti_operacion
)
SELECT 
acti_id,
acti_nombre,
acti_estado,
acti_url,
now(),
$2,
func_id,
'D'
FROM core.actividad
WHERE acti_id=$1;

 DELETE FROM core.actividad
WHERE acti_id=$1;


IF NOT FOUND THEN
    RETURN 0;
ELSE return 1;
END IF;
END;
$_$;


ALTER FUNCTION core.pr_core_d_actividad(numeric, character varying) OWNER TO pamplona;

--
-- TOC entry 231 (class 1255 OID 164251)
-- Name: pr_core_d_permisos(numeric, character varying); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_d_permisos(numeric, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN

 INSERT INTO core.aud_permisos(
perm_id,
perm_estado,
perm_fecharegistro,
perm_registradopor,
acti_id,
pers_id,
perm_operacion
)
SELECT 
perm_id,
perm_estado,
now(),
$2,
acti_id,
pers_id,
'D'
FROM core.permisos
WHERE perm_id=$1;

 DELETE FROM core.permisos
WHERE perm_id=$1;


IF NOT FOUND THEN
    RETURN 0;
ELSE return 1;
END IF;
END;
$_$;


ALTER FUNCTION core.pr_core_d_permisos(numeric, character varying) OWNER TO pamplona;

--
-- TOC entry 225 (class 1255 OID 164200)
-- Name: pr_core_d_persona(numeric, character varying); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_d_persona(numeric, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN

 INSERT INTO core.aud_persona(
pers_id,
pers_documento,
pers_primernombre,
pers_segundonombre,
pers_primerapellido,
pers_segundoapellido,
pers_genero,
pers_fechanacimiento,
pers_estado,
pers_fecharegistro,
pers_registradopor,
pers_operacion
)
SELECT 
pers_id,
pers_documento,
pers_primernombre,
pers_segundonombre,
pers_primerapellido,
pers_segundoapellido,
pers_genero,
pers_fechanacimiento,
pers_estado,
now(),
$2,
'D'
FROM core.persona
WHERE pers_id=$1;

 DELETE FROM core.persona
WHERE pers_id=$1;


IF NOT FOUND THEN
    RETURN 0;
ELSE return 1;
END IF;
END;
$_$;


ALTER FUNCTION core.pr_core_d_persona(numeric, character varying) OWNER TO pamplona;

--
-- TOC entry 226 (class 1255 OID 164156)
-- Name: pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('core.s_acti_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO core.actividad(
acti_id,
acti_nombre,
acti_estado,
acti_url,
acti_registradopor,
func_id,
acti_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
$5,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION core.pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) OWNER TO pamplona;

--
-- TOC entry 211 (class 1255 OID 163999)
-- Name: pr_core_i_control(character varying, character varying, character varying); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_i_control(character varying, character varying, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('core.s_cont_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO core.control(
cont_id,
cont_revision,
cont_fragmento,
cont_registradopor,
cont_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION core.pr_core_i_control(character varying, character varying, character varying) OWNER TO pamplona;

--
-- TOC entry 216 (class 1255 OID 164053)
-- Name: pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('core.s_func_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO core.funcionalidad(
func_id,
func_nombre,
func_estado,
func_url,
func_registradopor,
modu_id,
func_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
$5,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION core.pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) OWNER TO pamplona;

--
-- TOC entry 214 (class 1255 OID 164024)
-- Name: pr_core_i_modulo(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('core.s_modu_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO core.modulo(
modu_id,
modu_nombre,
modu_estado,
modu_url,
modu_registradopor,
modu_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION core.pr_core_i_modulo(character varying, character varying, character varying, character varying) OWNER TO pamplona;

--
-- TOC entry 232 (class 1255 OID 164252)
-- Name: pr_core_i_permisos(character varying, character varying, numeric, numeric); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('core.s_perm_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO core.permisos(
perm_id,
perm_estado,
perm_registradopor,
acti_id,
pers_id,
perm_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION core.pr_core_i_permisos(character varying, character varying, numeric, numeric) OWNER TO pamplona;

--
-- TOC entry 229 (class 1255 OID 164201)
-- Name: pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying); Type: FUNCTION; Schema: core; Owner: postgres
--

CREATE FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('core.s_pers_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO core.persona(
pers_id,
pers_documento,
pers_primernombre,
pers_segundonombre,
pers_primerapellido,
pers_segundoapellido,
pers_genero,
pers_fechanacimiento,
pers_estado,
pers_registradopor,
pers_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
$5,
$6,
$7,
$8,
$9,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION core.pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) OWNER TO pamplona;

SET search_path = public, pg_catalog;

--
-- TOC entry 217 (class 1255 OID 164040)
-- Name: crear_tabla_aud(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION crear_tabla_aud(character varying, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
campo varchar(50);
tipo  varchar(50);
prefijo varchar(5);
salida text;
campos CURSOR IS SELECT a.attname,format_type(t.oid,a.atttypmod)
	FROM pg_class c, pg_attribute a, pg_type t, pg_catalog.pg_namespace e
	WHERE c.relname = $2
	AND a.attnum > 0
	AND a.attrelid = c.oid
	AND a.atttypid = t.oid
	and c.relnamespace=e.oid
	and e.nspname =$1;
begin
salida:='';
salida:=salida||CHR(10)||CHR(10)||'CREATE TABLE '||$1||'.aud_'||$2||'('||CHR(10);

OPEN campos;
LOOP	
FETCH campos INTO campo,tipo;
IF campo like '%_registradopor'  then

prefijo=substr(campo,1,position('_' in campo));
END IF;
IF campo IS NOT NULL THEN
salida=salida||''||campo||' '||tipo||','||CHR(10);
END IF;

EXIT WHEN NOT FOUND;
END LOOP;
CLOSE campos;

salida=salida||prefijo||'operacion character varying(1) not null);'||CHR(10)||CHR(10);
salida=salida||'grant insert ON '||$1||'.aud_'||$2||' TO '||$1||';'||CHR(10)||CHR(10);
salida=salida||'alter table '||$1||'.aud_'||$2||' alter column '||prefijo||'registradopor set not null;'||CHR(10)||CHR(10);
salida=salida||'alter table '||$1||'.aud_'||$2||' alter column '||prefijo||'fecharegistro set not null;'||CHR(10)||CHR(10);
salida=salida||'alter table '||$1||'.aud_'||$2||' alter column '||prefijo||'operacion set not null;'||CHR(10)||CHR(10);

RAISE NOTICE 'tabla: %',salida;
return 1;
end;
$_$;


ALTER FUNCTION public.crear_tabla_aud(character varying, character varying) OWNER TO pamplona;

--
-- TOC entry 218 (class 1255 OID 164041)
-- Name: crear_trigger(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION crear_trigger(character varying, character varying, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE 
n integer;
nombre VARCHAR(200);
cadena VARCHAR(8000);
aux VARCHAR(1000);
aux2 VARCHAR(1000);
aux3 VARCHAR(20);
esquema varchar(50);
tabla varchar(50);
tipo varchar(1);
campo varchar(50);
tipoc VARCHAR(10);
campos CURSOR IS SELECT a.attname
	FROM pg_class c, pg_attribute a, pg_type t, pg_catalog.pg_namespace e
	WHERE c.relname = 'aud_'||$2
	AND a.attnum > 0
	AND a.attrelid = c.oid
	AND a.atttypid = t.oid
	and c.relnamespace=e.oid
	and e.nspname =$1;
BEGIN
esquema:=$1;
tabla:=$2;
tipo:=$3;
IF UPPER(TIPO)='I'  OR UPPER(TIPO)='U' THEN
    tipoc='new.';
ELSE IF UPPER(TIPO)='D' THEN
	tipoc='old.';
     END IF;
END IF;

cadena='

CREATE OR REPLACE FUNCTION ';
nombre:=lower(esquema||'.f_'||esquema||'_'||tipo||'_aud_'||tabla)||'()';
cadena:=cadena||nombre||'
RETURNS "trigger" AS 
';
cadena:=cadena||'$BODY$
BEGIN
';
cadena:=cadena||'INSERT INTO '||esquema||'.aud_'||tabla||'(';
aux:='';
aux2:='';
aux3:='';
OPEN campos;
LOOP	
FETCH campos INTO campo;
IF campo IS NOT NULL AND  campo not like '%_operacion' THEN
aux:=aux||campo||',  ';
aux2:=aux2||tipoc||campo||',  ';
END IF;
IF campo like '%_operacion'THEN
aux3:=campo;
END IF;

EXIT WHEN NOT FOUND;
END LOOP;
CLOSE campos;
n:=octet_length(aux);
aux:= substring(aux,0,n);
n:=octet_length(aux2);
aux2:= substring(aux2,0,n);

cadena:=cadena||aux||aux3||')
 VALUES('||aux2||''''||UPPER(tipo)||''');
';
cadena:=cadena||'RETURN '||substr(tipoc,1,length(tipoc)-1)||';

END;
$BODY$
LANGUAGE ''plpgsql''  VOLATILE;


 ';

cadena:=cadena||'CREATE TRIGGER tr_'||LOWER(tipo)||'_'||tabla||'
AFTER ';
IF UPPER(TIPO)='I' THEN
    cadena:=cadena||'INSERT
';
ELSE IF UPPER(TIPO)='U' THEN
	cadena:=cadena||'UPDATE
';
     ELSE IF UPPER(TIPO)='D' THEN
	      cadena:=cadena||'DELETE
';
	END IF;
    END IF;
END IF;
cadena:=cadena||' ON '||esquema||'.'||tabla||'
 FOR EACH ROW 
 EXECUTE PROCEDURE '||nombre||';


';
RAISE NOTICE '%',cadena;
IF N=0 THEN
return 0;
ELSE return 1;
END IF;
END;
$_$;


ALTER FUNCTION public.crear_trigger(character varying, character varying, character varying) OWNER TO pamplona;

--
-- TOC entry 219 (class 1255 OID 164042)
-- Name: generar_proc_borrado2(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION generar_proc_borrado2(character varying, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
l integer;
l2 integer;
campo varchar(50);
tipo  varchar(50);
cadena varchar(2000);
salida text;
consulta refcursor;
ind integer;
nombre varchar(200);
final varchar(2000);
aux varchar(2000);
aux2 varchar(2000);
aux3 varchar(2000);
esquema varchar(100);
tabla varchar(100);
campos CURSOR IS SELECT a.attname
	FROM pg_class c, pg_attribute a, pg_type t, pg_catalog.pg_namespace e
	WHERE c.relname = 'aud_'||$2
	AND a.attnum > 0
	AND a.attrelid = c.oid
	AND a.atttypid = t.oid
	and c.relnamespace=e.oid
	and e.nspname =$1;
BEGIN
esquema:=$1;
tabla:=$2;
select conkey,substr(array_dims(conkey),4,1) INTO cadena,l
from pg_constraint c,pg_namespace n,pg_class cl
where c.connamespace=n.oid
and c.conrelid=cl.oid
and cl.relnamespace=n.oid
and c.contype='p'
and n.nspname=$1
and cl.relname=$2;

l2=l*2+1;
cadena=substr(cadena,2,l2-2);
cadena='SELECT a.attname,t.typname
	FROM pg_class c, pg_attribute a, pg_type t, pg_catalog.pg_namespace e
	WHERE c.relname = '''||tabla||'''
	AND a.attnum in('||cadena||')
	AND a.attrelid = c.oid
	AND a.atttypid = t.oid
	and c.relnamespace=e.oid
	and e.nspname ='''||esquema||'''';

ind=0;
final='WHERE ';
nombre:=lower(esquema||'.pr_'||esquema||'_d_'||tabla)||'( ';

open consulta for execute cadena;
while (ind<l)loop
ind=ind+1;
FETCH consulta INTO campo,tipo;
nombre:=nombre||tipo||',';
IF ind=1 THEN
final:=final||campo||'=$'||ind;
ELSE final:=final||' AND '||campo||'=$'||ind;
END IF;
end loop;
close consulta;
nombre:=nombre||'varchar)';

salida:=CHR(10)||' CREATE OR REPLACE FUNCTION '||nombre||CHR(10);
salida:=salida||' RETURNS numeric AS'||CHR(10)||'$'||'BODY'||'$'||CHR(10)||'DECLARE'||CHR(10)||'BEGIN'||CHR(10)||CHR(10);
salida:=salida||' INSERT INTO '||esquema||'.aud_'||tabla||'('||CHR(10);

aux:='';
aux2:='SELECT '||CHR(10);
OPEN campos;
LOOP	
FETCH campos INTO campo;
IF campo IS NOT NULL AND  campo not like '%_operacion' THEN
	aux:=aux||campo||','||CHR(10);
	IF lower(campo) like '%_fecharegistro' THEN
		aux2:=aux2||'now(),'||CHR(10);
	ELSIF lower(campo) like '%_registradopor' THEN
			aux2:=aux2||'$'||(l+1)||','||CHR(10);
	ELSEIF lower(campo) like '%_operacion' THEN
			aux2:=aux2||'$'||(l+2)||','||CHR(10);
	   ELSE aux2:=aux2||campo||','||CHR(10);
	END IF;
END IF;
IF campo like '%_operacion'THEN
aux3:=campo;
END IF;
EXIT WHEN NOT FOUND;
END LOOP;
CLOSE campos;
salida:=salida||aux||aux3||CHR(10)||')'||CHR(10);
salida:=salida||aux2||'''D'''||CHR(10);
salida:=salida||'FROM '||esquema||'.'||tabla||CHR(10);
salida:=salida||final||';'||CHR(10)||CHR(10);

salida:=salida||' DELETE FROM '||esquema||'.'||tabla||CHR(10);
salida:=salida||final||';'||CHR(10)||CHR(10);

salida:=salida||CHR(10)||'IF NOT FOUND THEN'||CHR(10)||'    RETURN 0;'||CHR(10)||'ELSE return 1;'||CHR(10)||'END IF;'||CHR(10);
salida:=salida||'END;'||CHR(10)||'$'||'BODY'||'$'||CHR(10)||'LANGUAGE ''plpgsql'' VOLATILE;';
salida:=salida||'ALTER FUNCTION '||nombre||' OWNER TO pamplona;'||CHR(10);
salida:=salida||'GRANT EXECUTE ON FUNCTION '||nombre||' TO postgres;'||CHR(10);
salida:=salida||'GRANT EXECUTE ON FUNCTION '||nombre||' TO '||$1||';'||CHR(10)||CHR(10);

RAISE NOTICE 'PROCEDURE: %',salida;
return 1;
END;
$_$;


ALTER FUNCTION public.generar_proc_borrado2(character varying, character varying) OWNER TO pamplona;

--
-- TOC entry 220 (class 1255 OID 164043)
-- Name: generar_proc_insercion(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION generar_proc_insercion(character varying, character varying, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
nombre varchar(200);
b integer;
par integer;
prefijo alias for $3;
campo varchar(50);
tipo  varchar(50);
cadena1 varchar(2000);
cadena2 varchar(2000);
cadena3 text;
salida text;
consulta refcursor;
tabla alias for $2;
esquema alias for $1;
campos CURSOR IS SELECT a.attname,t.typname
	FROM pg_class c, pg_attribute a, pg_type t, pg_catalog.pg_namespace e
	WHERE c.relname = $2
	AND a.attnum > 0
	AND a.attrelid = c.oid
	AND a.atttypid = t.oid
	and c.relnamespace=e.oid
	and e.nspname =$1;
BEGIN

nombre:=lower(esquema||'.pr_'||esquema||'_i_'||tabla)||'( ';

b=0;
par=1;
cadena1:='';
cadena2:='';
cadena3:='';
OPEN campos;
LOOP	
FETCH campos INTO campo,tipo;
IF prefijo||'_id'<>campo and prefijo||'_fecharegistro'<>campo  then
cadena1=cadena1||campo||','||CHR(10);
cadena2=cadena2||tipo||',';
cadena3=cadena3||'$'||par||','||CHR(10);
par=par+1;
END IF;

IF prefijo||'_id'=campo then
B=1;
END IF;

EXIT WHEN NOT FOUND;
END LOOP;
CLOSE campos;
--cadena1=substr(cadena1,1,length(cadena1)-1);
cadena2=substr(cadena2,1,length(cadena2)-1);
--cadena3=substr(cadena3,1,length(cadena3)-1);

salida:=CHR(10)||CHR(10)||CHR(10)||' CREATE OR REPLACE FUNCTION '||nombre||cadena2||')';
salida:=salida||' RETURNS numeric AS'||CHR(10)||'$'||'BODY'||'$'||CHR(10)||'DECLARE'||CHR(10)||' seq numeric;'||CHR(10)||' BEGIN'||CHR(10)||CHR(10);
salida:=salida||'select into seq nextval ('''||esquema||'.s_'||prefijo||'_id'');'||CHR(10)||CHR(10)||' IF NOT FOUND THEN'||CHR(10)||'RETURN -1;'||CHR(10)||'else'||CHR(10)||CHR(10);
salida:=salida||' INSERT INTO '||esquema||'.'||tabla||'('||CHR(10)||prefijo||'_id,'||CHR(10)||cadena1||prefijo||'_fecharegistro'||')'||CHR(10)||'VALUES('||CHR(10)||'seq,'||CHR(10);
salida:=salida||cadena3||'now());'||CHR(10);
salida:=salida||CHR(10)||'IF NOT FOUND THEN'||CHR(10)||'RETURN -1; '||CHR(10)||'ELSE '||CHR(10)||'RETURN seq; '||CHR(10)||'END IF;'||CHR(10)||'end if;'||CHR(10)||'END;';
salida:=salida||CHR(10)||'$'||'BODY'||'$'||CHR(10);
salida:=salida||'LANGUAGE ''plpgsql'' VOLATILE;'||CHR(10)||CHR(10);
salida:=salida||'ALTER FUNCTION '||nombre||cadena2||') OWNER TO pamplona;'||CHR(10);
salida:=salida||'GRANT EXECUTE ON FUNCTION '||nombre||cadena2||') TO postgres;'||CHR(10);
salida:=salida||'GRANT EXECUTE ON FUNCTION '||nombre||cadena2||') TO '||$1||';'||CHR(10)||CHR(10);
IF B=0 THEN
RAISE NOTICE 'LLAVE PRIMARIA COMPUESTA: %.%',esquema,tabla;
return 0;
END IF;


RAISE NOTICE 'PROCEDURE: %',salida;
return 1;
END;
$_$;


ALTER FUNCTION public.generar_proc_insercion(character varying, character varying, character varying) OWNER TO pamplona;

--
-- TOC entry 203 (class 1255 OID 163981)
-- Name: plpgsql_call_handler(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    LANGUAGE c
    AS '$libdir/plpgsql', 'plpgsql_call_handler';


ALTER FUNCTION public.plpgsql_call_handler() OWNER TO pamplona;

SET search_path = web, pg_catalog;

--
-- TOC entry 241 (class 1255 OID 164376)
-- Name: f_web_i_aud_menu(); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION f_web_i_aud_menu() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO web.aud_menu(menu_id,  menu_nombre,  manu_ubicacion,  menu_estado,  menu_fecharegistro,  menu_registradopor,  menu_item,  pagi_id, menu_operacion)
 VALUES(new.menu_id,  new.menu_nombre,  new.manu_ubicacion,  new.menu_estado,  new.menu_fecharegistro,  new.menu_registradopor,  new.menu_item,  new.pagi_id, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION web.f_web_i_aud_menu() OWNER TO pamplona;

--
-- TOC entry 239 (class 1255 OID 164346)
-- Name: f_web_i_aud_pagina(); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION f_web_i_aud_pagina() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO web.aud_pagina(pagi_id,  pagi_nombre,  pagi_contenido,  pagi_url,  pagi_estado,  pagi_fecharegistro,  pagi_registradopor, pagi_operacion)
 VALUES(new.pagi_id,  new.pagi_nombre,  new.pagi_contenido,  new.pagi_url,  new.pagi_estado,  new.pagi_fecharegistro,  new.pagi_registradopor, 'I');
RETURN new;

END;
$$;


ALTER FUNCTION web.f_web_i_aud_pagina() OWNER TO pamplona;

--
-- TOC entry 242 (class 1255 OID 164378)
-- Name: f_web_u_aud_menu(); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION f_web_u_aud_menu() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO web.aud_menu(menu_id,  menu_nombre,  manu_ubicacion,  menu_estado,  menu_fecharegistro,  menu_registradopor,  menu_item,  pagi_id, menu_operacion)
 VALUES(new.menu_id,  new.menu_nombre,  new.manu_ubicacion,  new.menu_estado,  new.menu_fecharegistro,  new.menu_registradopor,  new.menu_item,  new.pagi_id, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION web.f_web_u_aud_menu() OWNER TO pamplona;

--
-- TOC entry 240 (class 1255 OID 164348)
-- Name: f_web_u_aud_pagina(); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION f_web_u_aud_pagina() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
INSERT INTO web.aud_pagina(pagi_id,  pagi_nombre,  pagi_contenido,  pagi_url,  pagi_estado,  pagi_fecharegistro,  pagi_registradopor, pagi_operacion)
 VALUES(new.pagi_id,  new.pagi_nombre,  new.pagi_contenido,  new.pagi_url,  new.pagi_estado,  new.pagi_fecharegistro,  new.pagi_registradopor, 'U');
RETURN new;

END;
$$;


ALTER FUNCTION web.f_web_u_aud_pagina() OWNER TO pamplona;

--
-- TOC entry 237 (class 1255 OID 164374)
-- Name: pr_web_d_menu(numeric, character varying); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION pr_web_d_menu(numeric, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN

 INSERT INTO web.aud_menu(
menu_id,
menu_nombre,
manu_ubicacion,
menu_estado,
menu_fecharegistro,
menu_registradopor,
menu_item,
pagi_id,
menu_operacion
)
SELECT 
menu_id,
menu_nombre,
manu_ubicacion,
menu_estado,
now(),
$2,
menu_item,
pagi_id,
'D'
FROM web.menu
WHERE menu_id=$1;

 DELETE FROM web.menu
WHERE menu_id=$1;


IF NOT FOUND THEN
    RETURN 0;
ELSE return 1;
END IF;
END;
$_$;


ALTER FUNCTION web.pr_web_d_menu(numeric, character varying) OWNER TO pamplona;

--
-- TOC entry 235 (class 1255 OID 164344)
-- Name: pr_web_d_pagina(numeric, character varying); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION pr_web_d_pagina(numeric, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
BEGIN

 INSERT INTO web.aud_pagina(
pagi_id,
pagi_nombre,
pagi_contenido,
pagi_url,
pagi_estado,
pagi_fecharegistro,
pagi_registradopor,
pagi_operacion
)
SELECT 
pagi_id,
pagi_nombre,
pagi_contenido,
pagi_url,
pagi_estado,
now(),
$2,
'D'
FROM web.pagina
WHERE pagi_id=$1;

 DELETE FROM web.pagina
WHERE pagi_id=$1;


IF NOT FOUND THEN
    RETURN 0;
ELSE return 1;
END IF;
END;
$_$;


ALTER FUNCTION web.pr_web_d_pagina(numeric, character varying) OWNER TO pamplona;

--
-- TOC entry 236 (class 1255 OID 164375)
-- Name: pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('web.s_menu_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO web.menu(
menu_id,
menu_nombre,
manu_ubicacion,
menu_estado,
menu_registradopor,
menu_item,
pagi_id,
menu_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
$5,
$6,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION web.pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) OWNER TO pamplona;

--
-- TOC entry 238 (class 1255 OID 164345)
-- Name: pr_web_i_pagina(character varying, text, character varying, character varying, character varying); Type: FUNCTION; Schema: web; Owner: postgres
--

CREATE FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
DECLARE
 seq numeric;
 BEGIN

select into seq nextval ('web.s_pagi_id');

 IF NOT FOUND THEN
RETURN -1;
else

 INSERT INTO web.pagina(
pagi_id,
pagi_nombre,
pagi_contenido,
pagi_url,
pagi_estado,
pagi_registradopor,
pagi_fecharegistro)
VALUES(
seq,
$1,
$2,
$3,
$4,
$5,
now());

IF NOT FOUND THEN
RETURN -1; 
ELSE 
RETURN seq; 
END IF;
end if;
END;
$_$;


ALTER FUNCTION web.pr_web_i_pagina(character varying, text, character varying, character varying, character varying) OWNER TO pamplona;

SET search_path = core, pg_catalog;

--
-- TOC entry 183 (class 1259 OID 164152)
-- Name: s_acti_id; Type: SEQUENCE; Schema: core; Owner: postgres
--

CREATE SEQUENCE s_acti_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE core.s_acti_id OWNER TO pamplona;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 181 (class 1259 OID 164130)
-- Name: actividad; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE actividad (
    acti_id numeric(30,0) DEFAULT nextval('s_acti_id'::regclass) NOT NULL,
    acti_nombre character varying(150) NOT NULL,
    acti_estado character varying(1) NOT NULL,
    acti_url character varying(200) NOT NULL,
    acti_fecharegistro timestamp without time zone NOT NULL,
    acti_registradopor character varying(150) NOT NULL,
    func_id numeric(30,0) NOT NULL,
    CONSTRAINT acti_estado_ck CHECK (((acti_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[])))
);


ALTER TABLE core.actividad OWNER TO pamplona;

--
-- TOC entry 2169 (class 0 OID 0)
-- Dependencies: 181
-- Name: TABLE actividad; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON TABLE actividad IS 'Tabla que almacena la informacion de las actividades de una funcionalidad';


--
-- TOC entry 2170 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.acti_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.acti_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2171 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.acti_nombre; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.acti_nombre IS 'Campo que almacena el nombre de la actividad';


--
-- TOC entry 2172 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.acti_estado; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.acti_estado IS 'Campo que almacena el estado de la actividad 1: Activo 2:Inactivo';


--
-- TOC entry 2173 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.acti_url; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.acti_url IS 'Campo que almacena la url de la actividad';


--
-- TOC entry 2174 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.acti_fecharegistro; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.acti_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2175 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.acti_registradopor; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.acti_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


--
-- TOC entry 2176 (class 0 OID 0)
-- Dependencies: 181
-- Name: COLUMN actividad.func_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN actividad.func_id IS 'Llave foranea de la tabla funcionalidad';


--
-- TOC entry 182 (class 1259 OID 164146)
-- Name: aud_actividad; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_actividad (
    acti_id numeric(30,0),
    acti_nombre character varying(150),
    acti_estado character varying(1),
    acti_url character varying(200),
    acti_fecharegistro timestamp without time zone NOT NULL,
    acti_registradopor character varying(150) NOT NULL,
    func_id numeric(30,0),
    acti_operacion character varying(1) NOT NULL
);


ALTER TABLE core.aud_actividad OWNER TO pamplona;

--
-- TOC entry 173 (class 1259 OID 163993)
-- Name: aud_control; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_control (
    cont_id numeric(30,0),
    cont_revision character varying(50),
    cont_fragmento character varying(100),
    cont_fecharegistro timestamp without time zone NOT NULL,
    cont_registradopor character varying(150) NOT NULL,
    cont_operacion character varying(1) NOT NULL
);


ALTER TABLE core.aud_control OWNER TO pamplona;

--
-- TOC entry 179 (class 1259 OID 164095)
-- Name: aud_funcionalidad; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_funcionalidad (
    func_id numeric(30,0),
    func_nombre character varying(150),
    func_estado character varying(1),
    func_url character varying(200),
    func_fecharegistro timestamp without time zone NOT NULL,
    func_registradopor character varying(150) NOT NULL,
    modu_id numeric(30,0),
    func_operacion character varying(1) NOT NULL
);


ALTER TABLE core.aud_funcionalidad OWNER TO pamplona;

--
-- TOC entry 176 (class 1259 OID 164015)
-- Name: aud_modulo; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_modulo (
    modu_id numeric(30,0),
    modu_nombre character varying(150),
    modu_estado character varying(1),
    modu_url character varying(200),
    modu_fecharegistro timestamp without time zone NOT NULL,
    modu_registradopor character varying(150) NOT NULL,
    modu_operacion character varying(1) NOT NULL
);


ALTER TABLE core.aud_modulo OWNER TO pamplona;

--
-- TOC entry 188 (class 1259 OID 164245)
-- Name: aud_permisos; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_permisos (
    perm_id numeric(30,0),
    perm_estado character varying(1),
    perm_fecharegistro timestamp without time zone NOT NULL,
    perm_registradopor character varying(150) NOT NULL,
    acti_id numeric(30,0),
    pers_id numeric(30,0),
    perm_operacion character varying(1) NOT NULL
);


ALTER TABLE core.aud_permisos OWNER TO pamplona;

--
-- TOC entry 185 (class 1259 OID 164191)
-- Name: aud_persona; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_persona (
    pers_id numeric(30,0),
    pers_documento character varying(50),
    pers_primernombre character varying(150),
    pers_segundonombre character varying(150),
    pers_primerapellido character varying(150),
    pers_segundoapellido character varying(150),
    pers_genero character varying(1),
    pers_fechanacimiento date,
    pers_estado character varying(1),
    pers_fecharegistro timestamp without time zone NOT NULL,
    pers_registradopor character varying(150) NOT NULL,
    pers_operacion character varying(1) NOT NULL
);


ALTER TABLE core.aud_persona OWNER TO pamplona;

--
-- TOC entry 174 (class 1259 OID 163996)
-- Name: s_cont_id; Type: SEQUENCE; Schema: core; Owner: postgres
--

CREATE SEQUENCE s_cont_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE core.s_cont_id OWNER TO pamplona;

--
-- TOC entry 172 (class 1259 OID 163986)
-- Name: control; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE control (
    cont_id numeric(30,0) DEFAULT nextval('s_cont_id'::regclass) NOT NULL,
    cont_revision character varying(50) NOT NULL,
    cont_fragmento character varying(100) NOT NULL,
    cont_fecharegistro timestamp without time zone NOT NULL,
    cont_registradopor character varying(150) NOT NULL
);


ALTER TABLE core.control OWNER TO pamplona;

--
-- TOC entry 2185 (class 0 OID 0)
-- Dependencies: 172
-- Name: TABLE control; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON TABLE control IS 'Tabla que almacena la informacion de las revisiones y los respectivos fragmentos ejecutados en la base de datos';


--
-- TOC entry 2186 (class 0 OID 0)
-- Dependencies: 172
-- Name: COLUMN control.cont_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN control.cont_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2187 (class 0 OID 0)
-- Dependencies: 172
-- Name: COLUMN control.cont_revision; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN control.cont_revision IS 'Campo que almacena la revision';


--
-- TOC entry 2188 (class 0 OID 0)
-- Dependencies: 172
-- Name: COLUMN control.cont_fragmento; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN control.cont_fragmento IS 'Campo que almacena los fragmentos de la revision';


--
-- TOC entry 2189 (class 0 OID 0)
-- Dependencies: 172
-- Name: COLUMN control.cont_fecharegistro; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN control.cont_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2190 (class 0 OID 0)
-- Dependencies: 172
-- Name: COLUMN control.cont_registradopor; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN control.cont_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


--
-- TOC entry 180 (class 1259 OID 164101)
-- Name: s_func_id; Type: SEQUENCE; Schema: core; Owner: postgres
--

CREATE SEQUENCE s_func_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE core.s_func_id OWNER TO pamplona;

--
-- TOC entry 178 (class 1259 OID 164079)
-- Name: funcionalidad; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE funcionalidad (
    func_id numeric(30,0) DEFAULT nextval('s_func_id'::regclass) NOT NULL,
    func_nombre character varying(150) NOT NULL,
    func_estado character varying(1) NOT NULL,
    func_url character varying(200) NOT NULL,
    func_fecharegistro timestamp without time zone NOT NULL,
    func_registradopor character varying(150) NOT NULL,
    modu_id numeric(30,0) NOT NULL,
    CONSTRAINT func_estado_ck CHECK (((func_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[])))
);


ALTER TABLE core.funcionalidad OWNER TO pamplona;

--
-- TOC entry 2193 (class 0 OID 0)
-- Dependencies: 178
-- Name: TABLE funcionalidad; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON TABLE funcionalidad IS 'Tabla que almacena la informacion del funcionalidades de un modulo';


--
-- TOC entry 2194 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.func_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.func_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2195 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.func_nombre; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.func_nombre IS 'Campo que almacena el nombre de la funcionalidad';


--
-- TOC entry 2196 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.func_estado; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.func_estado IS 'Campo que almacena el estado del modulo 1: Activo 2:Inactivo';


--
-- TOC entry 2197 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.func_url; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.func_url IS 'Campo que almacena la url de la funcionalidad';


--
-- TOC entry 2198 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.func_fecharegistro; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.func_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2199 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.func_registradopor; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.func_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


--
-- TOC entry 2200 (class 0 OID 0)
-- Dependencies: 178
-- Name: COLUMN funcionalidad.modu_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN funcionalidad.modu_id IS 'Llave foranea de la tabla modulo';


--
-- TOC entry 177 (class 1259 OID 164021)
-- Name: s_modu_id; Type: SEQUENCE; Schema: core; Owner: postgres
--

CREATE SEQUENCE s_modu_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE core.s_modu_id OWNER TO pamplona;

--
-- TOC entry 175 (class 1259 OID 164004)
-- Name: modulo; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE modulo (
    modu_id numeric(30,0) DEFAULT nextval('s_modu_id'::regclass) NOT NULL,
    modu_nombre character varying(150) NOT NULL,
    modu_estado character varying(1) NOT NULL,
    modu_url character varying(200) NOT NULL,
    modu_fecharegistro timestamp without time zone NOT NULL,
    modu_registradopor character varying(150) NOT NULL,
    CONSTRAINT modu_estado_ck CHECK (((modu_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[])))
);


ALTER TABLE core.modulo OWNER TO pamplona;

--
-- TOC entry 2203 (class 0 OID 0)
-- Dependencies: 175
-- Name: TABLE modulo; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON TABLE modulo IS 'Tabla que almacena la informacion de las revisiones y los respectivos fragmentos ejecutados en la base de datos';


--
-- TOC entry 2204 (class 0 OID 0)
-- Dependencies: 175
-- Name: COLUMN modulo.modu_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN modulo.modu_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2205 (class 0 OID 0)
-- Dependencies: 175
-- Name: COLUMN modulo.modu_nombre; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN modulo.modu_nombre IS 'Campo que almacena el nombre del modulo';


--
-- TOC entry 2206 (class 0 OID 0)
-- Dependencies: 175
-- Name: COLUMN modulo.modu_estado; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN modulo.modu_estado IS 'Campo que almacena el estado del modulo 1: Activo 2:Inactivo';


--
-- TOC entry 2207 (class 0 OID 0)
-- Dependencies: 175
-- Name: COLUMN modulo.modu_url; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN modulo.modu_url IS 'Campo que almacena la url del modulo';


--
-- TOC entry 2208 (class 0 OID 0)
-- Dependencies: 175
-- Name: COLUMN modulo.modu_fecharegistro; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN modulo.modu_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2209 (class 0 OID 0)
-- Dependencies: 175
-- Name: COLUMN modulo.modu_registradopor; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN modulo.modu_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


--
-- TOC entry 189 (class 1259 OID 164248)
-- Name: s_perm_id; Type: SEQUENCE; Schema: core; Owner: postgres
--

CREATE SEQUENCE s_perm_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE core.s_perm_id OWNER TO pamplona;

--
-- TOC entry 187 (class 1259 OID 164227)
-- Name: permisos; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE permisos (
    perm_id numeric(30,0) DEFAULT nextval('s_perm_id'::regclass) NOT NULL,
    perm_estado character varying(1) NOT NULL,
    perm_fecharegistro timestamp without time zone NOT NULL,
    perm_registradopor character varying(150) NOT NULL,
    acti_id numeric(30,0) NOT NULL,
    pers_id numeric(30,0) NOT NULL,
    CONSTRAINT perm_estado_ck CHECK (((perm_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[])))
);


ALTER TABLE core.permisos OWNER TO pamplona;

--
-- TOC entry 2212 (class 0 OID 0)
-- Dependencies: 187
-- Name: TABLE permisos; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON TABLE permisos IS 'Tabla que almacena la informacion de los permisos de las personas';


--
-- TOC entry 2213 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN permisos.perm_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN permisos.perm_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2214 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN permisos.perm_estado; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN permisos.perm_estado IS 'Campo que almacena el estado del permiso 1: Activo 2:Inactivo';


--
-- TOC entry 2215 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN permisos.perm_fecharegistro; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN permisos.perm_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2216 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN permisos.perm_registradopor; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN permisos.perm_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


--
-- TOC entry 2217 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN permisos.acti_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN permisos.acti_id IS 'Llave foranea de la tabla core.actividad';


--
-- TOC entry 2218 (class 0 OID 0)
-- Dependencies: 187
-- Name: COLUMN permisos.pers_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN permisos.pers_id IS 'Llave foranea de la tabla core.persona';


--
-- TOC entry 186 (class 1259 OID 164197)
-- Name: s_pers_id; Type: SEQUENCE; Schema: core; Owner: postgres
--

CREATE SEQUENCE s_pers_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE core.s_pers_id OWNER TO pamplona;

--
-- TOC entry 184 (class 1259 OID 164181)
-- Name: persona; Type: TABLE; Schema: core; Owner: postgres; Tablespace: 
--

CREATE TABLE persona (
    pers_id numeric(30,0) DEFAULT nextval('s_pers_id'::regclass) NOT NULL,
    pers_documento character varying(50) NOT NULL,
    pers_primernombre character varying(150) NOT NULL,
    pers_segundonombre character varying(150),
    pers_primerapellido character varying(150) NOT NULL,
    pers_segundoapellido character varying(150),
    pers_genero character varying(1) NOT NULL,
    pers_fechanacimiento date NOT NULL,
    pers_estado character varying(1) NOT NULL,
    pers_fecharegistro timestamp without time zone NOT NULL,
    pers_registradopor character varying(150) NOT NULL,
    CONSTRAINT pers_estado_ck CHECK (((pers_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[]))),
    CONSTRAINT pers_genero_ck CHECK (((pers_genero)::text = ANY ((ARRAY['M'::character varying, 'F'::character varying])::text[])))
);


ALTER TABLE core.persona OWNER TO pamplona;

--
-- TOC entry 2221 (class 0 OID 0)
-- Dependencies: 184
-- Name: TABLE persona; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON TABLE persona IS 'Tabla que almacena la informacion de las personas';


--
-- TOC entry 2222 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_id; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2223 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_documento; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_documento IS 'Campo que almacena el numero de documento';


--
-- TOC entry 2224 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_primernombre; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_primernombre IS 'Campo que almacena el primer nombre';


--
-- TOC entry 2225 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_segundonombre; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_segundonombre IS 'Campo que almacena el segundo nombre';


--
-- TOC entry 2226 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_primerapellido; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_primerapellido IS 'Campo que almacena el primer apellido';


--
-- TOC entry 2227 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_segundoapellido; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_segundoapellido IS 'Campo que almacena el segundo apellido';


--
-- TOC entry 2228 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_genero; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_genero IS 'Campo que almacena el genero M: Masculino F: Femenino';


--
-- TOC entry 2229 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_fechanacimiento; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_fechanacimiento IS 'Campo que almacena la fecha de nacimiento';


--
-- TOC entry 2230 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_estado; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_estado IS 'Campo que almacena el estado de la actividad 1: Activo 2:Inactivo';


--
-- TOC entry 2231 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_fecharegistro; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2232 (class 0 OID 0)
-- Dependencies: 184
-- Name: COLUMN persona.pers_registradopor; Type: COMMENT; Schema: core; Owner: postgres
--

COMMENT ON COLUMN persona.pers_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


SET search_path = web, pg_catalog;

--
-- TOC entry 194 (class 1259 OID 164368)
-- Name: aud_menu; Type: TABLE; Schema: web; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_menu (
    menu_id numeric(30,0),
    menu_nombre character varying(150),
    manu_ubicacion character varying(100),
    menu_estado character varying(1),
    menu_fecharegistro timestamp without time zone NOT NULL,
    menu_registradopor character varying(150) NOT NULL,
    menu_item numeric(30,0),
    pagi_id numeric(30,0),
    menu_operacion character varying(1) NOT NULL
);


ALTER TABLE web.aud_menu OWNER TO pamplona;

--
-- TOC entry 191 (class 1259 OID 164335)
-- Name: aud_pagina; Type: TABLE; Schema: web; Owner: postgres; Tablespace: 
--

CREATE TABLE aud_pagina (
    pagi_id numeric(30,0),
    pagi_nombre character varying(300),
    pagi_contenido text,
    pagi_url character varying(200),
    pagi_estado character varying(1),
    pagi_fecharegistro timestamp without time zone NOT NULL,
    pagi_registradopor character varying(150) NOT NULL,
    pagi_operacion character varying(1) NOT NULL
);


ALTER TABLE web.aud_pagina OWNER TO pamplona;

--
-- TOC entry 195 (class 1259 OID 164371)
-- Name: s_menu_id; Type: SEQUENCE; Schema: web; Owner: postgres
--

CREATE SEQUENCE s_menu_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE web.s_menu_id OWNER TO pamplona;

--
-- TOC entry 193 (class 1259 OID 164350)
-- Name: menu; Type: TABLE; Schema: web; Owner: postgres; Tablespace: 
--

CREATE TABLE menu (
    menu_id numeric(30,0) DEFAULT nextval('s_menu_id'::regclass) NOT NULL,
    menu_nombre character varying(150) NOT NULL,
    manu_ubicacion character varying(100) NOT NULL,
    menu_estado character varying(1) NOT NULL,
    menu_fecharegistro timestamp without time zone NOT NULL,
    menu_registradopor character varying(150) NOT NULL,
    menu_item numeric(30,0),
    pagi_id numeric(30,0),
    CONSTRAINT menu_estado_ck CHECK (((menu_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[])))
);


ALTER TABLE web.menu OWNER TO pamplona;

--
-- TOC entry 2237 (class 0 OID 0)
-- Dependencies: 193
-- Name: TABLE menu; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON TABLE menu IS 'Tabla que almacena la informacion de los menus del sitio';


--
-- TOC entry 2238 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.menu_id; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.menu_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2239 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.menu_nombre; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.menu_nombre IS 'Campo que almacena el nombre del menu';


--
-- TOC entry 2240 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.manu_ubicacion; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.manu_ubicacion IS 'Campo que almacena la ubicacion del menu';


--
-- TOC entry 2241 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.menu_estado; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.menu_estado IS 'Campo que almacena el estado del permiso 1: Activo 2:Inactivo';


--
-- TOC entry 2242 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.menu_fecharegistro; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.menu_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2243 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.menu_registradopor; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.menu_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


--
-- TOC entry 2244 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.menu_item; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.menu_item IS 'Llave foranea de la tabla web.menu';


--
-- TOC entry 2245 (class 0 OID 0)
-- Dependencies: 193
-- Name: COLUMN menu.pagi_id; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN menu.pagi_id IS 'Llave foranea de la tabla web.pagina';


--
-- TOC entry 192 (class 1259 OID 164341)
-- Name: s_pagi_id; Type: SEQUENCE; Schema: web; Owner: postgres
--

CREATE SEQUENCE s_pagi_id
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE web.s_pagi_id OWNER TO pamplona;

--
-- TOC entry 190 (class 1259 OID 164324)
-- Name: pagina; Type: TABLE; Schema: web; Owner: postgres; Tablespace: 
--

CREATE TABLE pagina (
    pagi_id numeric(30,0) DEFAULT nextval('s_pagi_id'::regclass) NOT NULL,
    pagi_nombre character varying(300) NOT NULL,
    pagi_contenido text NOT NULL,
    pagi_url character varying(200) NOT NULL,
    pagi_estado character varying(1) NOT NULL,
    pagi_fecharegistro timestamp without time zone NOT NULL,
    pagi_registradopor character varying(150) NOT NULL,
    CONSTRAINT pagi_estado_ck CHECK (((pagi_estado)::text = ANY ((ARRAY['1'::character varying, '0'::character varying])::text[])))
);


ALTER TABLE web.pagina OWNER TO pamplona;

--
-- TOC entry 2248 (class 0 OID 0)
-- Dependencies: 190
-- Name: TABLE pagina; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON TABLE pagina IS 'Tabla que almacena la informacion de los permisos de las personas';


--
-- TOC entry 2249 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_id; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_id IS 'Es el identificador único de la tabla.';


--
-- TOC entry 2250 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_nombre; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_nombre IS 'Campo que almacena el nombre de la pagina';


--
-- TOC entry 2251 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_contenido; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_contenido IS 'Campo que almacena el contenido de la pagina';


--
-- TOC entry 2252 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_url; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_url IS 'Campo que almacena el la url de la pagina';


--
-- TOC entry 2253 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_estado; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_estado IS 'Campo que almacena el estado del permiso 1: Activo 2:Inactivo';


--
-- TOC entry 2254 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_fecharegistro; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_fecharegistro IS 'Campo de auditoría que almacena la fecha del ultimo cambio realizado.';


--
-- TOC entry 2255 (class 0 OID 0)
-- Dependencies: 190
-- Name: COLUMN pagina.pagi_registradopor; Type: COMMENT; Schema: web; Owner: postgres
--

COMMENT ON COLUMN pagina.pagi_registradopor IS 'Campo de auditoría el nombre de quien realizo la ultima modificación.';


SET search_path = core, pg_catalog;

--
-- TOC entry 2130 (class 0 OID 164130)
-- Dependencies: 181
-- Data for Name: actividad; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY actividad (acti_id, acti_nombre, acti_estado, acti_url, acti_fecharegistro, acti_registradopor, func_id) FROM stdin;
\.


--
-- TOC entry 2131 (class 0 OID 164146)
-- Dependencies: 182
-- Data for Name: aud_actividad; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY aud_actividad (acti_id, acti_nombre, acti_estado, acti_url, acti_fecharegistro, acti_registradopor, func_id, acti_operacion) FROM stdin;
\.


--
-- TOC entry 2122 (class 0 OID 163993)
-- Dependencies: 173
-- Data for Name: aud_control; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY aud_control (cont_id, cont_revision, cont_fragmento, cont_fecharegistro, cont_registradopor, cont_operacion) FROM stdin;
1	BET1.0.00.00	020820151630.SQL	2015-09-04 20:09:37.520022	1094245295	I
2	BET1.0.00.00	CreacionUsuariosPostgres.SQL	2015-09-04 20:09:37.531187	1094245295	I
4	BET1.0.00.00	020820151640.SQL	2015-09-04 20:10:55.755355	1094245295	I
5	BET1.0.00.00	030820151100.SQL	2015-09-04 20:12:19.584632	1094245295	I
6	BET1.0.00.00	040920152012.SQL	2015-09-04 20:29:05.803592	1094245295	I
9	BET1.0.00.00	040920152042.\r\nSQL	2015-09-04 20:56:35.718452	1094245295	I
10	BET1.0.00.00	040920152059.\r\nSQL	2015-09-04 21:23:35.434184	1094245295	I
11	BET1.0.00.00	040920152124.\r\nSQL	2015-09-04 21:35:37.222535	1094245295	I
12	BET1.0.00.00	040920152144.\r\nSQL	2015-09-04 22:30:47.765785	1094245295	I
\.


--
-- TOC entry 2128 (class 0 OID 164095)
-- Dependencies: 179
-- Data for Name: aud_funcionalidad; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY aud_funcionalidad (func_id, func_nombre, func_estado, func_url, func_fecharegistro, func_registradopor, modu_id, func_operacion) FROM stdin;
\.


--
-- TOC entry 2125 (class 0 OID 164015)
-- Dependencies: 176
-- Data for Name: aud_modulo; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY aud_modulo (modu_id, modu_nombre, modu_estado, modu_url, modu_fecharegistro, modu_registradopor, modu_operacion) FROM stdin;
\.


--
-- TOC entry 2137 (class 0 OID 164245)
-- Dependencies: 188
-- Data for Name: aud_permisos; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY aud_permisos (perm_id, perm_estado, perm_fecharegistro, perm_registradopor, acti_id, pers_id, perm_operacion) FROM stdin;
\.


--
-- TOC entry 2134 (class 0 OID 164191)
-- Dependencies: 185
-- Data for Name: aud_persona; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY aud_persona (pers_id, pers_documento, pers_primernombre, pers_segundonombre, pers_primerapellido, pers_segundoapellido, pers_genero, pers_fechanacimiento, pers_estado, pers_fecharegistro, pers_registradopor, pers_operacion) FROM stdin;
\.


--
-- TOC entry 2121 (class 0 OID 163986)
-- Dependencies: 172
-- Data for Name: control; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY control (cont_id, cont_revision, cont_fragmento, cont_fecharegistro, cont_registradopor) FROM stdin;
1	BET1.0.00.00	020820151630.SQL	2015-09-04 20:09:37.520022	1094245295
2	BET1.0.00.00	CreacionUsuariosPostgres.SQL	2015-09-04 20:09:37.531187	1094245295
4	BET1.0.00.00	020820151640.SQL	2015-09-04 20:10:55.755355	1094245295
5	BET1.0.00.00	030820151100.SQL	2015-09-04 20:12:19.584632	1094245295
6	BET1.0.00.00	040920152012.SQL	2015-09-04 20:29:05.803592	1094245295
9	BET1.0.00.00	040920152042.\r\nSQL	2015-09-04 20:56:35.718452	1094245295
10	BET1.0.00.00	040920152059.\r\nSQL	2015-09-04 21:23:35.434184	1094245295
11	BET1.0.00.00	040920152124.\r\nSQL	2015-09-04 21:35:37.222535	1094245295
12	BET1.0.00.00	040920152144.\r\nSQL	2015-09-04 22:30:47.765785	1094245295
\.


--
-- TOC entry 2127 (class 0 OID 164079)
-- Dependencies: 178
-- Data for Name: funcionalidad; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY funcionalidad (func_id, func_nombre, func_estado, func_url, func_fecharegistro, func_registradopor, modu_id) FROM stdin;
\.


--
-- TOC entry 2124 (class 0 OID 164004)
-- Dependencies: 175
-- Data for Name: modulo; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY modulo (modu_id, modu_nombre, modu_estado, modu_url, modu_fecharegistro, modu_registradopor) FROM stdin;
\.


--
-- TOC entry 2136 (class 0 OID 164227)
-- Dependencies: 187
-- Data for Name: permisos; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY permisos (perm_id, perm_estado, perm_fecharegistro, perm_registradopor, acti_id, pers_id) FROM stdin;
\.


--
-- TOC entry 2133 (class 0 OID 164181)
-- Dependencies: 184
-- Data for Name: persona; Type: TABLE DATA; Schema: core; Owner: postgres
--

COPY persona (pers_id, pers_documento, pers_primernombre, pers_segundonombre, pers_primerapellido, pers_segundoapellido, pers_genero, pers_fechanacimiento, pers_estado, pers_fecharegistro, pers_registradopor) FROM stdin;
\.


--
-- TOC entry 2257 (class 0 OID 0)
-- Dependencies: 183
-- Name: s_acti_id; Type: SEQUENCE SET; Schema: core; Owner: postgres
--

SELECT pg_catalog.setval('s_acti_id', 1, false);


--
-- TOC entry 2258 (class 0 OID 0)
-- Dependencies: 174
-- Name: s_cont_id; Type: SEQUENCE SET; Schema: core; Owner: postgres
--

SELECT pg_catalog.setval('s_cont_id', 13, true);


--
-- TOC entry 2259 (class 0 OID 0)
-- Dependencies: 180
-- Name: s_func_id; Type: SEQUENCE SET; Schema: core; Owner: postgres
--

SELECT pg_catalog.setval('s_func_id', 1, false);


--
-- TOC entry 2260 (class 0 OID 0)
-- Dependencies: 177
-- Name: s_modu_id; Type: SEQUENCE SET; Schema: core; Owner: postgres
--

SELECT pg_catalog.setval('s_modu_id', 1, false);


--
-- TOC entry 2261 (class 0 OID 0)
-- Dependencies: 189
-- Name: s_perm_id; Type: SEQUENCE SET; Schema: core; Owner: postgres
--

SELECT pg_catalog.setval('s_perm_id', 1, false);


--
-- TOC entry 2262 (class 0 OID 0)
-- Dependencies: 186
-- Name: s_pers_id; Type: SEQUENCE SET; Schema: core; Owner: postgres
--

SELECT pg_catalog.setval('s_pers_id', 1, false);


SET search_path = web, pg_catalog;

--
-- TOC entry 2143 (class 0 OID 164368)
-- Dependencies: 194
-- Data for Name: aud_menu; Type: TABLE DATA; Schema: web; Owner: postgres
--

COPY aud_menu (menu_id, menu_nombre, manu_ubicacion, menu_estado, menu_fecharegistro, menu_registradopor, menu_item, pagi_id, menu_operacion) FROM stdin;
2	Principal	center-left	1	2015-09-05 22:44:54.587005	1094245295	\N	\N	I
2	Ley de trasparencia	center-left	1	2015-09-05 22:44:54.587005	1094245295	\N	\N	U
2	Ley de transparencia	center-left	1	2015-09-05 22:44:54.587005	1094245295	\N	\N	U
6	Organización	center-left	1	2015-09-05 23:35:08.037036	1094245295	2	\N	I
6	Organización	center-left	1	2015-09-05 23:35:08.037036	1094245295	2	3	U
7	Funciones y deberes	center-left	1	2015-09-05 23:47:00.191421	1094245295	2	\N	I
7	Funciones y deberes	center-left	1	2015-09-05 23:47:00.191421	1094245295	2	4	U
7	Organigrama	center-left	1	2015-09-05 23:47:00.191421	1094245295	2	4	U
9	Funciones y deberes	center-left	1	2015-09-06 02:10:17.838039	1094245295	2	\N	I
9	Funciones y deberes	center-left	1	2015-09-06 02:10:17.838039	1094245295	2	5	U
10	Presupuesto anual asignado 2015	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	6	I
11	Talento humano	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	7	I
12	Normas, Politicas, Lineamientos, y manuales	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	9	I
13	Indicadores de desempeño	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	11	I
14	Servicio al cliente	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	12	I
15	Trámites y Servicios de Registro Mercantil	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	13	I
16	Trámites y Servicios de ESALES	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	14	I
17	Trámites y Servicios de RUP	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	15	I
18	Trámites y Servicios de RNT	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	16	I
19	Trámites y Servicios de Registro de Vendedores de Juegos de Suerte y Azar	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	18	I
20	Trámites y Servicios de Entidades Extranjeras de Derecho Privado Sin Ánimo de Lucro	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	19	I
21	SIPREF	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	20	I
22	Supervisión y Vigilancia	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	21	I
23	Sistemas de Información	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	22	I
24	Documentos Ley de Transparencia	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	23	I
25	Inventario de publicaciones	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	24	I
\.


--
-- TOC entry 2140 (class 0 OID 164335)
-- Dependencies: 191
-- Data for Name: aud_pagina; Type: TABLE DATA; Schema: web; Owner: postgres
--

COPY aud_pagina (pagi_id, pagi_nombre, pagi_contenido, pagi_url, pagi_estado, pagi_fecharegistro, pagi_registradopor, pagi_operacion) FROM stdin;
3	Organización	Organización	organizacion.php	1	2015-09-05 23:46:00.131385	1094245295	I
3	Organización	Organización 1	organizacion.php	1	2015-09-05 23:46:00.131385	1094245295	U
4	Funciones y deberes	Estas son las funciones	funciones.php	1	2015-09-06 01:38:24.260084	1094245295	I
4	Organigrama	Estas son las funciones	funciones.php	1	2015-09-06 01:38:24.260084	1094245295	U
4	Organigrama	Orenigrama	funciones.php	1	2015-09-06 01:38:24.260084	1094245295	U
4	Organigrama	Orenigrama	organigrama.php	1	2015-09-06 01:38:24.260084	1094245295	U
5	Funciones y deberes	funciones	funciones.php	1	2015-09-06 02:11:06.381846	1094245295	I
6	Presupuesto anual asignado 2015	Presupuesto	presupuesto.php	1	2015-09-06 02:12:17.718731	1094245295	I
7	Talento humano	Talento	talento.php	1	2015-09-06 02:12:56.932226	1094245295	I
9	Normas, Politicas, Lineamientos, y manuales	Normas	normas.php	1	2015-09-06 02:14:08.445311	1094245295	I
11	Indicadores de desempeño	Indicadores	indicadores.php	1	2015-09-06 02:14:39.258174	1094245295	I
12	Servicio al cliente	servicio	servicio.php	1	2015-09-06 02:15:10.407204	1094245295	I
13	Trámites y Servicios de Registro Mercantil	Trámites y Servicios de Registro Mercantil	registros.php	1	2015-09-06 02:19:37.573827	1094245295	I
14	Trámites y Servicios de ESALES	Trámites y Servicios de ESALES	esales.php	1	2015-09-06 02:20:03.938281	1094245295	I
15	Trámites y Servicios de RUP	Trámites y Servicios de RUP	rup.php	1	2015-09-06 02:20:27.052066	1094245295	I
16	Trámites y Servicios de RNT	Trámites y Servicios de RNT	rnt.php	1	2015-09-06 02:20:49.952095	1094245295	I
18	Trámites y Servicios de Registro de Vendedores de Juegos de Suerte y Azar	Trámites y Servicios de Registro de Vendedores de Juegos de Suerte y Azar	juegos.php	1	2015-09-06 02:21:17.337435	1094245295	I
19	Trámites y Servicios de Entidades Extranjeras de Derecho Privado Sin Ánimo de Lucro	Trámites y Servicios de Entidades Extranjeras de Derecho Privado Sin Ánimo de Lucro	lucro.php	1	2015-09-06 02:21:41.248593	1094245295	I
20	SIPREF	SIPREF	sipref.php	1	2015-09-06 02:22:08.469964	1094245295	I
21	Supervisión y Vigilancia	Supervisión y Vigilancia	supervision.php	1	2015-09-06 02:22:30.996546	1094245295	I
22	Sistemas de Información	Sistemas de Información	sistemas.php	1	2015-09-06 02:22:50.623811	1094245295	I
23	Documentos Ley de Transparencia	Documentos Ley de Transparencia	transparencia	1	2015-09-06 02:23:16.244497	1094245295	I
24	Inventario de publicaciones	Inventario de publicaciones	publicaciones	1	2015-09-06 02:23:35.932157	1094245295	I
\.


--
-- TOC entry 2142 (class 0 OID 164350)
-- Dependencies: 193
-- Data for Name: menu; Type: TABLE DATA; Schema: web; Owner: postgres
--

COPY menu (menu_id, menu_nombre, manu_ubicacion, menu_estado, menu_fecharegistro, menu_registradopor, menu_item, pagi_id) FROM stdin;
2	Ley de transparencia	center-left	1	2015-09-05 22:44:54.587005	1094245295	\N	\N
6	Organización	center-left	1	2015-09-05 23:35:08.037036	1094245295	2	3
7	Organigrama	center-left	1	2015-09-05 23:47:00.191421	1094245295	2	4
9	Funciones y deberes	center-left	1	2015-09-06 02:10:17.838039	1094245295	2	5
10	Presupuesto anual asignado 2015	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	6
11	Talento humano	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	7
12	Normas, Politicas, Lineamientos, y manuales	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	9
13	Indicadores de desempeño	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	11
14	Servicio al cliente	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	12
15	Trámites y Servicios de Registro Mercantil	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	13
16	Trámites y Servicios de ESALES	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	14
17	Trámites y Servicios de RUP	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	15
18	Trámites y Servicios de RNT	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	16
19	Trámites y Servicios de Registro de Vendedores de Juegos de Suerte y Azar	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	18
20	Trámites y Servicios de Entidades Extranjeras de Derecho Privado Sin Ánimo de Lucro	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	19
21	SIPREF	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	20
22	Supervisión y Vigilancia	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	21
23	Sistemas de Información	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	22
24	Documentos Ley de Transparencia	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	23
25	Inventario de publicaciones	center-left	1	2015-09-06 02:27:54.288198	1094245295	2	24
\.


--
-- TOC entry 2139 (class 0 OID 164324)
-- Dependencies: 190
-- Data for Name: pagina; Type: TABLE DATA; Schema: web; Owner: postgres
--

COPY pagina (pagi_id, pagi_nombre, pagi_contenido, pagi_url, pagi_estado, pagi_fecharegistro, pagi_registradopor) FROM stdin;
3	Organización	Organización 1	organizacion.php	1	2015-09-05 23:46:00.131385	1094245295
4	Organigrama	Orenigrama	organigrama.php	1	2015-09-06 01:38:24.260084	1094245295
5	Funciones y deberes	funciones	funciones.php	1	2015-09-06 02:11:06.381846	1094245295
6	Presupuesto anual asignado 2015	Presupuesto	presupuesto.php	1	2015-09-06 02:12:17.718731	1094245295
7	Talento humano	Talento	talento.php	1	2015-09-06 02:12:56.932226	1094245295
9	Normas, Politicas, Lineamientos, y manuales	Normas	normas.php	1	2015-09-06 02:14:08.445311	1094245295
11	Indicadores de desempeño	Indicadores	indicadores.php	1	2015-09-06 02:14:39.258174	1094245295
12	Servicio al cliente	servicio	servicio.php	1	2015-09-06 02:15:10.407204	1094245295
13	Trámites y Servicios de Registro Mercantil	Trámites y Servicios de Registro Mercantil	registros.php	1	2015-09-06 02:19:37.573827	1094245295
14	Trámites y Servicios de ESALES	Trámites y Servicios de ESALES	esales.php	1	2015-09-06 02:20:03.938281	1094245295
15	Trámites y Servicios de RUP	Trámites y Servicios de RUP	rup.php	1	2015-09-06 02:20:27.052066	1094245295
16	Trámites y Servicios de RNT	Trámites y Servicios de RNT	rnt.php	1	2015-09-06 02:20:49.952095	1094245295
18	Trámites y Servicios de Registro de Vendedores de Juegos de Suerte y Azar	Trámites y Servicios de Registro de Vendedores de Juegos de Suerte y Azar	juegos.php	1	2015-09-06 02:21:17.337435	1094245295
19	Trámites y Servicios de Entidades Extranjeras de Derecho Privado Sin Ánimo de Lucro	Trámites y Servicios de Entidades Extranjeras de Derecho Privado Sin Ánimo de Lucro	lucro.php	1	2015-09-06 02:21:41.248593	1094245295
20	SIPREF	SIPREF	sipref.php	1	2015-09-06 02:22:08.469964	1094245295
21	Supervisión y Vigilancia	Supervisión y Vigilancia	supervision.php	1	2015-09-06 02:22:30.996546	1094245295
22	Sistemas de Información	Sistemas de Información	sistemas.php	1	2015-09-06 02:22:50.623811	1094245295
23	Documentos Ley de Transparencia	Documentos Ley de Transparencia	transparencia	1	2015-09-06 02:23:16.244497	1094245295
24	Inventario de publicaciones	Inventario de publicaciones	publicaciones	1	2015-09-06 02:23:35.932157	1094245295
\.


--
-- TOC entry 2263 (class 0 OID 0)
-- Dependencies: 195
-- Name: s_menu_id; Type: SEQUENCE SET; Schema: web; Owner: postgres
--

SELECT pg_catalog.setval('s_menu_id', 25, true);


--
-- TOC entry 2264 (class 0 OID 0)
-- Dependencies: 192
-- Name: s_pagi_id; Type: SEQUENCE SET; Schema: web; Owner: postgres
--

SELECT pg_catalog.setval('s_pagi_id', 24, true);


SET search_path = core, pg_catalog;

--
-- TOC entry 1975 (class 2606 OID 164139)
-- Name: acti_nombre_uk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY actividad
    ADD CONSTRAINT acti_nombre_uk UNIQUE (acti_nombre, func_id);


--
-- TOC entry 1981 (class 2606 OID 164233)
-- Name: acti_pers_uk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY permisos
    ADD CONSTRAINT acti_pers_uk UNIQUE (acti_id, pers_id);


--
-- TOC entry 1977 (class 2606 OID 164137)
-- Name: acti_pk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY actividad
    ADD CONSTRAINT acti_pk PRIMARY KEY (acti_id);


--
-- TOC entry 1963 (class 2606 OID 163990)
-- Name: cont_pk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY control
    ADD CONSTRAINT cont_pk PRIMARY KEY (cont_id);


--
-- TOC entry 1965 (class 2606 OID 163992)
-- Name: cont_revision_uk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY control
    ADD CONSTRAINT cont_revision_uk UNIQUE (cont_revision, cont_fragmento);


--
-- TOC entry 1971 (class 2606 OID 164088)
-- Name: func_nombre_uk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY funcionalidad
    ADD CONSTRAINT func_nombre_uk UNIQUE (func_nombre, modu_id);


--
-- TOC entry 1973 (class 2606 OID 164086)
-- Name: func_pk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY funcionalidad
    ADD CONSTRAINT func_pk PRIMARY KEY (func_id);


--
-- TOC entry 1967 (class 2606 OID 164013)
-- Name: modu_nombre_uk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY modulo
    ADD CONSTRAINT modu_nombre_uk UNIQUE (modu_nombre);


--
-- TOC entry 1969 (class 2606 OID 164011)
-- Name: modu_pk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY modulo
    ADD CONSTRAINT modu_pk PRIMARY KEY (modu_id);


--
-- TOC entry 1983 (class 2606 OID 164231)
-- Name: perm_pk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY permisos
    ADD CONSTRAINT perm_pk PRIMARY KEY (perm_id);


--
-- TOC entry 1979 (class 2606 OID 164188)
-- Name: pers_pk; Type: CONSTRAINT; Schema: core; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY persona
    ADD CONSTRAINT pers_pk PRIMARY KEY (pers_id);


SET search_path = web, pg_catalog;

--
-- TOC entry 1989 (class 2606 OID 164356)
-- Name: menu_nombre_uk; Type: CONSTRAINT; Schema: web; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY menu
    ADD CONSTRAINT menu_nombre_uk UNIQUE (menu_nombre);


--
-- TOC entry 1991 (class 2606 OID 164354)
-- Name: menu_pk; Type: CONSTRAINT; Schema: web; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY menu
    ADD CONSTRAINT menu_pk PRIMARY KEY (menu_id);


--
-- TOC entry 1985 (class 2606 OID 164331)
-- Name: pagi_pk; Type: CONSTRAINT; Schema: web; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pagina
    ADD CONSTRAINT pagi_pk PRIMARY KEY (pagi_id);


--
-- TOC entry 1987 (class 2606 OID 164333)
-- Name: pagi_url_uk; Type: CONSTRAINT; Schema: web; Owner: postgres; Tablespace: 
--

ALTER TABLE ONLY pagina
    ADD CONSTRAINT pagi_url_uk UNIQUE (pagi_url);


SET search_path = core, pg_catalog;

--
-- TOC entry 2004 (class 2620 OID 164158)
-- Name: tr_i_actividad; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_i_actividad AFTER INSERT ON actividad FOR EACH ROW EXECUTE PROCEDURE f_core_i_aud_actividad();


--
-- TOC entry 1998 (class 2620 OID 164001)
-- Name: tr_i_control; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_i_control AFTER INSERT ON control FOR EACH ROW EXECUTE PROCEDURE f_core_i_aud_control();


--
-- TOC entry 2002 (class 2620 OID 164105)
-- Name: tr_i_funcionalidad; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_i_funcionalidad AFTER INSERT ON funcionalidad FOR EACH ROW EXECUTE PROCEDURE f_core_i_aud_funcionalidad();


--
-- TOC entry 2000 (class 2620 OID 164026)
-- Name: tr_i_modulo; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_i_modulo AFTER INSERT ON modulo FOR EACH ROW EXECUTE PROCEDURE f_core_i_aud_modulo();


--
-- TOC entry 2008 (class 2620 OID 164254)
-- Name: tr_i_permisos; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_i_permisos AFTER INSERT ON permisos FOR EACH ROW EXECUTE PROCEDURE f_core_i_aud_permisos();


--
-- TOC entry 2006 (class 2620 OID 164203)
-- Name: tr_i_persona; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_i_persona AFTER INSERT ON persona FOR EACH ROW EXECUTE PROCEDURE f_core_i_aud_persona();


--
-- TOC entry 2005 (class 2620 OID 164160)
-- Name: tr_u_actividad; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_u_actividad AFTER UPDATE ON actividad FOR EACH ROW EXECUTE PROCEDURE f_core_u_aud_actividad();


--
-- TOC entry 1999 (class 2620 OID 164003)
-- Name: tr_u_control; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_u_control AFTER UPDATE ON control FOR EACH ROW EXECUTE PROCEDURE f_core_u_aud_control();


--
-- TOC entry 2003 (class 2620 OID 164107)
-- Name: tr_u_funcionalidad; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_u_funcionalidad AFTER UPDATE ON funcionalidad FOR EACH ROW EXECUTE PROCEDURE f_core_u_aud_funcionalidad();


--
-- TOC entry 2001 (class 2620 OID 164028)
-- Name: tr_u_modulo; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_u_modulo AFTER UPDATE ON modulo FOR EACH ROW EXECUTE PROCEDURE f_core_u_aud_modulo();


--
-- TOC entry 2009 (class 2620 OID 164256)
-- Name: tr_u_permisos; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_u_permisos AFTER UPDATE ON permisos FOR EACH ROW EXECUTE PROCEDURE f_core_u_aud_permisos();


--
-- TOC entry 2007 (class 2620 OID 164205)
-- Name: tr_u_persona; Type: TRIGGER; Schema: core; Owner: postgres
--

CREATE TRIGGER tr_u_persona AFTER UPDATE ON persona FOR EACH ROW EXECUTE PROCEDURE f_core_u_aud_persona();


SET search_path = web, pg_catalog;

--
-- TOC entry 2012 (class 2620 OID 164377)
-- Name: tr_i_menu; Type: TRIGGER; Schema: web; Owner: postgres
--

CREATE TRIGGER tr_i_menu AFTER INSERT ON menu FOR EACH ROW EXECUTE PROCEDURE f_web_i_aud_menu();


--
-- TOC entry 2010 (class 2620 OID 164347)
-- Name: tr_i_pagina; Type: TRIGGER; Schema: web; Owner: postgres
--

CREATE TRIGGER tr_i_pagina AFTER INSERT ON pagina FOR EACH ROW EXECUTE PROCEDURE f_web_i_aud_pagina();


--
-- TOC entry 2013 (class 2620 OID 164379)
-- Name: tr_u_menu; Type: TRIGGER; Schema: web; Owner: postgres
--

CREATE TRIGGER tr_u_menu AFTER UPDATE ON menu FOR EACH ROW EXECUTE PROCEDURE f_web_u_aud_menu();


--
-- TOC entry 2011 (class 2620 OID 164349)
-- Name: tr_u_pagina; Type: TRIGGER; Schema: web; Owner: postgres
--

CREATE TRIGGER tr_u_pagina AFTER UPDATE ON pagina FOR EACH ROW EXECUTE PROCEDURE f_web_u_aud_pagina();


SET search_path = core, pg_catalog;

--
-- TOC entry 1993 (class 2606 OID 164141)
-- Name: acti_modu_fk; Type: FK CONSTRAINT; Schema: core; Owner: postgres
--

ALTER TABLE ONLY actividad
    ADD CONSTRAINT acti_modu_fk FOREIGN KEY (func_id) REFERENCES funcionalidad(func_id);


--
-- TOC entry 1992 (class 2606 OID 164090)
-- Name: func_modu_fk; Type: FK CONSTRAINT; Schema: core; Owner: postgres
--

ALTER TABLE ONLY funcionalidad
    ADD CONSTRAINT func_modu_fk FOREIGN KEY (modu_id) REFERENCES modulo(modu_id);


--
-- TOC entry 1994 (class 2606 OID 164235)
-- Name: perm_acti_fk; Type: FK CONSTRAINT; Schema: core; Owner: postgres
--

ALTER TABLE ONLY permisos
    ADD CONSTRAINT perm_acti_fk FOREIGN KEY (acti_id) REFERENCES actividad(acti_id);


--
-- TOC entry 1995 (class 2606 OID 164240)
-- Name: perm_pers_fk; Type: FK CONSTRAINT; Schema: core; Owner: postgres
--

ALTER TABLE ONLY permisos
    ADD CONSTRAINT perm_pers_fk FOREIGN KEY (pers_id) REFERENCES persona(pers_id);


SET search_path = web, pg_catalog;

--
-- TOC entry 1996 (class 2606 OID 164358)
-- Name: menu_menu_fk; Type: FK CONSTRAINT; Schema: web; Owner: postgres
--

ALTER TABLE ONLY menu
    ADD CONSTRAINT menu_menu_fk FOREIGN KEY (menu_item) REFERENCES menu(menu_id);


--
-- TOC entry 1997 (class 2606 OID 164363)
-- Name: menu_pagi_fk; Type: FK CONSTRAINT; Schema: web; Owner: postgres
--

ALTER TABLE ONLY menu
    ADD CONSTRAINT menu_pagi_fk FOREIGN KEY (pagi_id) REFERENCES pagina(pagi_id);


--
-- TOC entry 2150 (class 0 OID 0)
-- Dependencies: 8
-- Name: core; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA core FROM PUBLIC;
REVOKE ALL ON SCHEMA core FROM postgres;
GRANT ALL ON SCHEMA core TO postgres;
GRANT USAGE ON SCHEMA core TO pamplona_aplibeethoven;
GRANT USAGE ON SCHEMA core TO pamplona_core;


--
-- TOC entry 2152 (class 0 OID 0)
-- Dependencies: 5
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- TOC entry 2153 (class 0 OID 0)
-- Dependencies: 7
-- Name: web; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA web FROM PUBLIC;
REVOKE ALL ON SCHEMA web FROM postgres;
GRANT ALL ON SCHEMA web TO postgres;
GRANT USAGE ON SCHEMA web TO pamplona_aplibeethoven;
GRANT USAGE ON SCHEMA web TO pamplona_web;


SET search_path = core, pg_catalog;

--
-- TOC entry 2155 (class 0 OID 0)
-- Dependencies: 224
-- Name: pr_core_d_actividad(numeric, character varying); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_d_actividad(numeric, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_d_actividad(numeric, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_core_d_actividad(numeric, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_core_d_actividad(numeric, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_d_actividad(numeric, character varying) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_d_actividad(numeric, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2156 (class 0 OID 0)
-- Dependencies: 231
-- Name: pr_core_d_permisos(numeric, character varying); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_d_permisos(numeric, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_d_permisos(numeric, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_core_d_permisos(numeric, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_core_d_permisos(numeric, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_d_permisos(numeric, character varying) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_d_permisos(numeric, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2157 (class 0 OID 0)
-- Dependencies: 225
-- Name: pr_core_d_persona(numeric, character varying); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_d_persona(numeric, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_d_persona(numeric, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_core_d_persona(numeric, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_core_d_persona(numeric, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_d_persona(numeric, character varying) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_d_persona(numeric, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2158 (class 0 OID 0)
-- Dependencies: 226
-- Name: pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) FROM postgres;
GRANT ALL ON FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) TO postgres;
GRANT ALL ON FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_i_actividad(character varying, character varying, character varying, character varying, numeric) TO pamplona_aplibeethoven;


--
-- TOC entry 2159 (class 0 OID 0)
-- Dependencies: 211
-- Name: pr_core_i_control(character varying, character varying, character varying); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_i_control(character varying, character varying, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_i_control(character varying, character varying, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_core_i_control(character varying, character varying, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_core_i_control(character varying, character varying, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_i_control(character varying, character varying, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2160 (class 0 OID 0)
-- Dependencies: 216
-- Name: pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) FROM postgres;
GRANT ALL ON FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) TO postgres;
GRANT ALL ON FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_i_funcionalidad(character varying, character varying, character varying, character varying, numeric) TO pamplona_aplibeethoven;


--
-- TOC entry 2161 (class 0 OID 0)
-- Dependencies: 214
-- Name: pr_core_i_modulo(character varying, character varying, character varying, character varying); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_i_modulo(character varying, character varying, character varying, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2162 (class 0 OID 0)
-- Dependencies: 232
-- Name: pr_core_i_permisos(character varying, character varying, numeric, numeric); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) FROM postgres;
GRANT ALL ON FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) TO postgres;
GRANT ALL ON FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_i_permisos(character varying, character varying, numeric, numeric) TO pamplona_aplibeethoven;


--
-- TOC entry 2163 (class 0 OID 0)
-- Dependencies: 229
-- Name: pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying); Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) TO pamplona_core;
GRANT ALL ON FUNCTION pr_core_i_persona(character varying, character varying, character varying, character varying, character varying, character varying, date, character varying, character varying) TO pamplona_aplibeethoven;


SET search_path = web, pg_catalog;

--
-- TOC entry 2164 (class 0 OID 0)
-- Dependencies: 237
-- Name: pr_web_d_menu(numeric, character varying); Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_web_d_menu(numeric, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_web_d_menu(numeric, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_web_d_menu(numeric, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_web_d_menu(numeric, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_web_d_menu(numeric, character varying) TO pamplona_web;
GRANT ALL ON FUNCTION pr_web_d_menu(numeric, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2165 (class 0 OID 0)
-- Dependencies: 235
-- Name: pr_web_d_pagina(numeric, character varying); Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_web_d_pagina(numeric, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_web_d_pagina(numeric, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_web_d_pagina(numeric, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_web_d_pagina(numeric, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_web_d_pagina(numeric, character varying) TO pamplona_web;
GRANT ALL ON FUNCTION pr_web_d_pagina(numeric, character varying) TO pamplona_aplibeethoven;


--
-- TOC entry 2166 (class 0 OID 0)
-- Dependencies: 236
-- Name: pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric); Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) FROM postgres;
GRANT ALL ON FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) TO postgres;
GRANT ALL ON FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) TO PUBLIC;
GRANT ALL ON FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) TO pamplona_web;
GRANT ALL ON FUNCTION pr_web_i_menu(character varying, character varying, character varying, character varying, numeric, numeric) TO pamplona_aplibeethoven;


--
-- TOC entry 2167 (class 0 OID 0)
-- Dependencies: 238
-- Name: pr_web_i_pagina(character varying, text, character varying, character varying, character varying); Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) FROM PUBLIC;
REVOKE ALL ON FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) FROM postgres;
GRANT ALL ON FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) TO postgres;
GRANT ALL ON FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) TO PUBLIC;
GRANT ALL ON FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) TO pamplona_web;
GRANT ALL ON FUNCTION pr_web_i_pagina(character varying, text, character varying, character varying, character varying) TO pamplona_aplibeethoven;


SET search_path = core, pg_catalog;

--
-- TOC entry 2168 (class 0 OID 0)
-- Dependencies: 183
-- Name: s_acti_id; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_acti_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_acti_id FROM postgres;
GRANT ALL ON SEQUENCE s_acti_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_acti_id TO pamplona_core;
GRANT SELECT,UPDATE ON SEQUENCE s_acti_id TO pamplona_aplibeethoven;


--
-- TOC entry 2177 (class 0 OID 0)
-- Dependencies: 181
-- Name: actividad; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE actividad FROM PUBLIC;
REVOKE ALL ON TABLE actividad FROM postgres;
GRANT ALL ON TABLE actividad TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE actividad TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE actividad TO pamplona_aplibeethoven;


--
-- TOC entry 2178 (class 0 OID 0)
-- Dependencies: 182
-- Name: aud_actividad; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE aud_actividad FROM PUBLIC;
REVOKE ALL ON TABLE aud_actividad FROM postgres;
GRANT ALL ON TABLE aud_actividad TO postgres;
GRANT INSERT ON TABLE aud_actividad TO pamplona_core;
GRANT INSERT ON TABLE aud_actividad TO pamplona_aplibeethoven;


--
-- TOC entry 2179 (class 0 OID 0)
-- Dependencies: 173
-- Name: aud_control; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE aud_control FROM PUBLIC;
REVOKE ALL ON TABLE aud_control FROM postgres;
GRANT ALL ON TABLE aud_control TO postgres;
GRANT INSERT ON TABLE aud_control TO pamplona_aplibeethoven;


--
-- TOC entry 2180 (class 0 OID 0)
-- Dependencies: 179
-- Name: aud_funcionalidad; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE aud_funcionalidad FROM PUBLIC;
REVOKE ALL ON TABLE aud_funcionalidad FROM postgres;
GRANT ALL ON TABLE aud_funcionalidad TO postgres;
GRANT INSERT ON TABLE aud_funcionalidad TO pamplona_core;
GRANT INSERT ON TABLE aud_funcionalidad TO pamplona_aplibeethoven;


--
-- TOC entry 2181 (class 0 OID 0)
-- Dependencies: 176
-- Name: aud_modulo; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE aud_modulo FROM PUBLIC;
REVOKE ALL ON TABLE aud_modulo FROM postgres;
GRANT ALL ON TABLE aud_modulo TO postgres;
GRANT INSERT ON TABLE aud_modulo TO pamplona_core;
GRANT INSERT ON TABLE aud_modulo TO pamplona_aplibeethoven;


--
-- TOC entry 2182 (class 0 OID 0)
-- Dependencies: 188
-- Name: aud_permisos; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE aud_permisos FROM PUBLIC;
REVOKE ALL ON TABLE aud_permisos FROM postgres;
GRANT ALL ON TABLE aud_permisos TO postgres;
GRANT INSERT ON TABLE aud_permisos TO pamplona_core;
GRANT INSERT ON TABLE aud_permisos TO pamplona_aplibeethoven;


--
-- TOC entry 2183 (class 0 OID 0)
-- Dependencies: 185
-- Name: aud_persona; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE aud_persona FROM PUBLIC;
REVOKE ALL ON TABLE aud_persona FROM postgres;
GRANT ALL ON TABLE aud_persona TO postgres;
GRANT INSERT ON TABLE aud_persona TO pamplona_core;
GRANT INSERT ON TABLE aud_persona TO pamplona_aplibeethoven;


--
-- TOC entry 2184 (class 0 OID 0)
-- Dependencies: 174
-- Name: s_cont_id; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_cont_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_cont_id FROM postgres;
GRANT ALL ON SEQUENCE s_cont_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_cont_id TO pamplona_aplibeethoven;


--
-- TOC entry 2191 (class 0 OID 0)
-- Dependencies: 172
-- Name: control; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE control FROM PUBLIC;
REVOKE ALL ON TABLE control FROM postgres;
GRANT ALL ON TABLE control TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE control TO pamplona_aplibeethoven;


--
-- TOC entry 2192 (class 0 OID 0)
-- Dependencies: 180
-- Name: s_func_id; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_func_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_func_id FROM postgres;
GRANT ALL ON SEQUENCE s_func_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_func_id TO pamplona_core;
GRANT SELECT,UPDATE ON SEQUENCE s_func_id TO pamplona_aplibeethoven;


--
-- TOC entry 2201 (class 0 OID 0)
-- Dependencies: 178
-- Name: funcionalidad; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE funcionalidad FROM PUBLIC;
REVOKE ALL ON TABLE funcionalidad FROM postgres;
GRANT ALL ON TABLE funcionalidad TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE funcionalidad TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE funcionalidad TO pamplona_aplibeethoven;


--
-- TOC entry 2202 (class 0 OID 0)
-- Dependencies: 177
-- Name: s_modu_id; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_modu_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_modu_id FROM postgres;
GRANT ALL ON SEQUENCE s_modu_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_modu_id TO pamplona_core;
GRANT SELECT,UPDATE ON SEQUENCE s_modu_id TO pamplona_aplibeethoven;


--
-- TOC entry 2210 (class 0 OID 0)
-- Dependencies: 175
-- Name: modulo; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE modulo FROM PUBLIC;
REVOKE ALL ON TABLE modulo FROM postgres;
GRANT ALL ON TABLE modulo TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE modulo TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE modulo TO pamplona_aplibeethoven;


--
-- TOC entry 2211 (class 0 OID 0)
-- Dependencies: 189
-- Name: s_perm_id; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_perm_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_perm_id FROM postgres;
GRANT ALL ON SEQUENCE s_perm_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_perm_id TO pamplona_core;
GRANT SELECT,UPDATE ON SEQUENCE s_perm_id TO pamplona_aplibeethoven;


--
-- TOC entry 2219 (class 0 OID 0)
-- Dependencies: 187
-- Name: permisos; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE permisos FROM PUBLIC;
REVOKE ALL ON TABLE permisos FROM postgres;
GRANT ALL ON TABLE permisos TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE permisos TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE permisos TO pamplona_aplibeethoven;


--
-- TOC entry 2220 (class 0 OID 0)
-- Dependencies: 186
-- Name: s_pers_id; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_pers_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_pers_id FROM postgres;
GRANT ALL ON SEQUENCE s_pers_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_pers_id TO pamplona_core;
GRANT SELECT,UPDATE ON SEQUENCE s_pers_id TO pamplona_aplibeethoven;


--
-- TOC entry 2233 (class 0 OID 0)
-- Dependencies: 184
-- Name: persona; Type: ACL; Schema: core; Owner: postgres
--

REVOKE ALL ON TABLE persona FROM PUBLIC;
REVOKE ALL ON TABLE persona FROM postgres;
GRANT ALL ON TABLE persona TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE persona TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE persona TO pamplona_aplibeethoven;


SET search_path = web, pg_catalog;

--
-- TOC entry 2234 (class 0 OID 0)
-- Dependencies: 194
-- Name: aud_menu; Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON TABLE aud_menu FROM PUBLIC;
REVOKE ALL ON TABLE aud_menu FROM postgres;
GRANT ALL ON TABLE aud_menu TO postgres;
GRANT INSERT ON TABLE aud_menu TO pamplona_web;
GRANT INSERT ON TABLE aud_menu TO pamplona_aplibeethoven;


--
-- TOC entry 2235 (class 0 OID 0)
-- Dependencies: 191
-- Name: aud_pagina; Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON TABLE aud_pagina FROM PUBLIC;
REVOKE ALL ON TABLE aud_pagina FROM postgres;
GRANT ALL ON TABLE aud_pagina TO postgres;
GRANT INSERT ON TABLE aud_pagina TO pamplona_web;
GRANT INSERT ON TABLE aud_pagina TO pamplona_aplibeethoven;


--
-- TOC entry 2236 (class 0 OID 0)
-- Dependencies: 195
-- Name: s_menu_id; Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_menu_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_menu_id FROM postgres;
GRANT ALL ON SEQUENCE s_menu_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_menu_id TO pamplona_web;
GRANT SELECT,UPDATE ON SEQUENCE s_menu_id TO pamplona_aplibeethoven;


--
-- TOC entry 2246 (class 0 OID 0)
-- Dependencies: 193
-- Name: menu; Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON TABLE menu FROM PUBLIC;
REVOKE ALL ON TABLE menu FROM postgres;
GRANT ALL ON TABLE menu TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE menu TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE menu TO pamplona_aplibeethoven;


--
-- TOC entry 2247 (class 0 OID 0)
-- Dependencies: 192
-- Name: s_pagi_id; Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON SEQUENCE s_pagi_id FROM PUBLIC;
REVOKE ALL ON SEQUENCE s_pagi_id FROM postgres;
GRANT ALL ON SEQUENCE s_pagi_id TO postgres;
GRANT SELECT,UPDATE ON SEQUENCE s_pagi_id TO pamplona_web;
GRANT SELECT,UPDATE ON SEQUENCE s_pagi_id TO pamplona_aplibeethoven;


--
-- TOC entry 2256 (class 0 OID 0)
-- Dependencies: 190
-- Name: pagina; Type: ACL; Schema: web; Owner: postgres
--

REVOKE ALL ON TABLE pagina FROM PUBLIC;
REVOKE ALL ON TABLE pagina FROM postgres;
GRANT ALL ON TABLE pagina TO postgres;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE pagina TO pamplona_core;
GRANT SELECT,INSERT,REFERENCES,DELETE,UPDATE ON TABLE pagina TO pamplona_aplibeethoven;


-- Completed on 2015-09-06 03:30:19 COT

--
-- PostgreSQL database dump complete
--

